/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.featuremanager.matcher.biome;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.terraforged.engine.world.biome.map.BiomeContext;
import com.terraforged.mod.biome.context.TFBiomeContext;
import com.terraforged.mod.featuremanager.matcher.biome.BiomeMatcherParser;
import com.terraforged.mod.featuremanager.modifier.Jsonifiable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class BiomeMatcher
implements Predicate<Biome>,
Comparable<BiomeMatcher>,
Jsonifiable {
    public static final BiomeMatcher ANY = new BiomeMatcher(Collections.emptySet());
    private final Set<Biome> biomes;

    private BiomeMatcher(Set<Biome> biomes) {
        this.biomes = biomes;
    }

    @Override
    public String getType() {
        return "biomes";
    }

    @Override
    public JsonElement toJson(BiomeContext<?> context) {
        if (!this.biomes.isEmpty()) {
            JsonArray array = new JsonArray();
            this.biomes.stream().map(ForgeRegistryEntry::getRegistryName).map(Objects::toString).sorted().forEach(arg_0 -> ((JsonArray)array).add(arg_0));
            return array;
        }
        return JsonNull.INSTANCE;
    }

    @Override
    public int compareTo(BiomeMatcher o) {
        return Integer.compare(o.biomes.size(), this.biomes.size());
    }

    @Override
    public boolean test(Biome biome) {
        return this.biomes.isEmpty() || this.biomes.contains(biome);
    }

    public BiomeMatcher or(BiomeMatcher other) {
        HashSet<Biome> combined = new HashSet<Biome>();
        combined.addAll(this.biomes);
        combined.addAll(other.biomes);
        return new BiomeMatcher(combined);
    }

    public static BiomeMatcher vanilla(TFBiomeContext context) {
        return BiomeMatcher.of(context, "minecraft:*");
    }

    public static BiomeMatcher of(TFBiomeContext context, Biome.Category ... types) {
        HashSet<Biome> biomes = new HashSet<Biome>();
        block0: for (Biome biome : context.biomes) {
            for (Biome.Category category : types) {
                if (biome.func_201856_r() != category) continue;
                biomes.add(biome);
                continue block0;
            }
        }
        if (biomes.isEmpty()) {
            return ANY;
        }
        return BiomeMatcher.of(biomes);
    }

    public static BiomeMatcher of(TFBiomeContext context, String ... biomes) {
        BiomeMatcherParser.Collector collector = new BiomeMatcherParser.Collector();
        for (String name : biomes) {
            BiomeMatcherParser.collectBiomes(name, collector, context);
        }
        return collector.create();
    }

    @SafeVarargs
    public static BiomeMatcher of(TFBiomeContext context, RegistryKey<Biome> ... biomes) {
        BiomeMatcherParser.Collector collector = new BiomeMatcherParser.Collector();
        for (RegistryKey<Biome> name : biomes) {
            BiomeMatcherParser.collectBiomes(name.func_240901_a_().toString(), collector, context);
        }
        return collector.create();
    }

    public static BiomeMatcher of(Biome biome) {
        return new BiomeMatcher(Collections.singleton(biome));
    }

    public static BiomeMatcher of(Set<Biome> biomes) {
        return new BiomeMatcher(biomes);
    }
}

